<?php
/**
 * Additional sections to add to admin_panel.php
 * Add these sections before the closing </body> tag
 */

// Add this after the Quiz Questions section (around line 420)
?>

    <!-- Notes with Text Content -->
    <div class="card mb-3">
      <div class="card-header">Notes (PDF / Video / Text)</div>
      <div class="card-body">
        <form method="post" enctype="multipart/form-data">
          <input type="hidden" name="entity" value="note">
          <div class="row g-2 mb-2">
            <div class="col-md-3">
              <select name="chapter_id" class="form-select" required>
                <option value="">Chapter</option>
                <?php foreach ($chapters as $ch): ?>
                  <option value="<?= $ch['id'] ?>"><?= htmlspecialchars($ch['title']) ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-3">
              <input type="text" name="pdf_url" class="form-control" placeholder="PDF URL">
            </div>
            <div class="col-md-3">
              <input type="text" name="video_url" class="form-control" placeholder="YouTube URL">
            </div>
            <div class="col-md-3">
              <button class="btn btn-primary w-100" type="submit">Add</button>
            </div>
          </div>
          <div class="mb-2">
            <label class="form-label">Text Content (for reading notes):</label>
            <textarea name="text_content" class="form-control" rows="5" placeholder="Enter text content here..."></textarea>
          </div>
        </form>
        <?php
          $notes = $pdo->query("SELECT * FROM notes ORDER BY id DESC LIMIT 50")->fetchAll();
        ?>
        <table class="table table-sm">
          <thead><tr><th>ID</th><th>Chapter</th><th>PDF</th><th>Video</th><th>Text</th></tr></thead>
          <tbody>
            <?php foreach ($notes as $n): ?>
              <tr>
                <td><?= $n['id'] ?></td>
                <td><?= $n['chapter_id'] ?></td>
                <td><?= $n['pdf_url'] ? '<a href="'.htmlspecialchars($n['pdf_url']).'" target="_blank">PDF</a>' : '-' ?></td>
                <td><?= $n['video_url'] ? '<a href="'.htmlspecialchars($n['video_url']).'" target="_blank">Video</a>' : '-' ?></td>
                <td><?= $n['text_content'] ? 'Yes ('.strlen($n['text_content']).' chars)' : '-' ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>

    <!-- Bulk Quiz Upload -->
    <div class="card mb-3">
      <div class="card-header">
        Bulk Quiz Upload
        <a href="quiz_format_template.txt" download class="btn btn-sm btn-outline-primary float-end">Download Format Template</a>
      </div>
      <div class="card-body">
        <div class="alert alert-info">
          <strong>Format:</strong> Text file (.txt) with pipe-separated values<br>
          Format: Question|Option A|Option B|Option C|Option D|Correct Answer (A/B/C/D)|Explanation<br>
          <strong>OR</strong> CSV file with same columns
        </div>
        <form method="post" enctype="multipart/form-data">
          <input type="hidden" name="entity" value="bulk_quiz">
          <div class="row g-2">
            <div class="col-md-3">
              <select name="chapter_id" class="form-select" required>
                <option value="">Select Chapter</option>
                <?php foreach ($chapters as $ch): ?>
                  <option value="<?= $ch['id'] ?>"><?= htmlspecialchars($ch['title']) ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-6">
              <input type="file" name="quiz_file" class="form-control" accept=".txt,.csv" required>
            </div>
            <div class="col-md-3">
              <button class="btn btn-success w-100" type="submit">Upload Questions</button>
            </div>
          </div>
        </form>
      </div>
    </div>

    <!-- Ads Management -->
    <div class="card mb-3">
      <div class="card-header">AdMob Ads Management</div>
      <div class="card-body">
        <form method="post">
          <input type="hidden" name="entity" value="ad">
          <div class="row g-2 mb-2">
            <div class="col-md-3">
              <select name="ad_type" class="form-select" required>
                <option value="banner">Banner Ad</option>
                <option value="interstitial">Interstitial Ad</option>
                <option value="rewarded">Rewarded Ad</option>
              </select>
            </div>
            <div class="col-md-4">
              <input type="text" name="ad_unit_id" class="form-control" placeholder="Ad Unit ID (ca-app-pub-...)" required>
            </div>
            <div class="col-md-2">
              <select name="status" class="form-select">
                <option value="active">Active</option>
                <option value="inactive">Inactive</option>
              </select>
            </div>
            <div class="col-md-2">
              <input type="text" name="position" class="form-control" placeholder="Position (e.g., home_bottom)">
            </div>
            <div class="col-md-1">
              <button class="btn btn-primary w-100" type="submit">Add</button>
            </div>
          </div>
        </form>
        <?php
          $ads = $pdo->query("SELECT * FROM ads_settings ORDER BY id DESC")->fetchAll();
        ?>
        <table class="table table-sm">
          <thead><tr><th>ID</th><th>Type</th><th>Ad Unit ID</th><th>Status</th><th>Position</th></tr></thead>
          <tbody>
            <?php foreach ($ads as $ad): ?>
              <tr>
                <td><?= $ad['id'] ?></td>
                <td><?= htmlspecialchars($ad['ad_type']) ?></td>
                <td><small><?= htmlspecialchars($ad['ad_unit_id']) ?></small></td>
                <td><?= htmlspecialchars($ad['status']) ?></td>
                <td><?= htmlspecialchars($ad['position']) ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>

<?php
// End of additions
?>
